/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hsc.objmgr.frame;

import com.ibm.hsc.common.exceptions.PIHscCmdMgrException;
import com.ibm.hsc.common.exceptions.PIHscServerException;
import com.ibm.hsc.common.util.MsVersionInfo;
import com.ibm.hsc.fsp.cmdhelpers.FspQueryData;
import com.ibm.hsc.objmgr.cec.OmCecMgr;
import com.ibm.hsc.objmgr.console.OmConsoleMgr;
import com.ibm.hsc.objmgr.console.OmHostsInfo;
import com.ibm.hsc.objmgr.frame.OmFrameAsyncHandler;
import com.ibm.hsc.objmgr.frame.OmFrameUpdater;
import com.ibm.hsc.objmgr.sys.OmSysMgr;
import com.ibm.hsc.rep.RException;
import com.ibm.hsc.rep.RObject;
import com.ibm.hsc.rep.RObjectId;
import com.ibm.hsc.rep.v50.R50Cage;
import com.ibm.hsc.rep.v50.R50Define;
import com.ibm.hsc.rep.v50.R50Frame;
import java.net.InetAddress;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Vector;
import org.snia.wbem.cim.UnsignedInt16;
import org.snia.wbem.cim.UnsignedInt8;

public class OmFrameMgr
extends OmSysMgr {
    private OmFrameUpdater mFrameUpdater = new OmFrameUpdater(this);

    public OmFrameMgr(FspQueryData fspQueryData, byte[] byArray) throws RException, PIHscCmdMgrException {
        super(fspQueryData, byArray);
        this.initialize(fspQueryData, byArray);
    }

    protected void rebuildConn() {
    }

    protected boolean repUpdateConnData(int n, int n2, int n3, FspQueryData fspQueryData, boolean bl) throws RException {
        boolean bl2;
        boolean bl3 = super.repUpdateConnData(n, n2, n3, fspQueryData, bl);
        Hashtable hashtable = this.mCmdMgr.getAllConnInfo();
        boolean bl4 = bl2 = hashtable.size() > 1;
        if (this.setProperty("SlaveFSPExists", (Object)new Boolean(bl2))) {
            System.out.println("hasDualBpc changed to " + bl2);
            bl3 = true;
        }
        this.bpcIsReady(fspQueryData, true);
        return bl3;
    }

    protected void updateQueryData(FspQueryData fspQueryData, byte[] byArray, boolean bl) throws PIHscServerException, RException {
        System.out.println("calling OmSysMgr::updateQueryData");
        super.updateQueryData(fspQueryData, byArray, bl);
        System.out.println("finish calling OmSysMgr::updateQueryData");
    }

    protected void createAsyncHandler() {
        System.out.println("Create the async event handler");
        this.mAsyncHandler = new OmFrameAsyncHandler(this);
    }

    protected void createRObject(FspQueryData fspQueryData, byte[] byArray) throws RException {
        RObjectId rObjectId = new RObjectId(1, R50Define.CID_IBMHSC_Frame);
        String string = this.mSysName;
        rObjectId.setKeyValue(0, string);
        rObjectId.setKeyValue(1, "IBMHSC_Frame");
        RObject rObject = new RObject(rObjectId);
        rObject.addInstance();
        this.mSysOid = rObjectId;
        this.mSysObj = this.mSysOid.getObject();
        this.mSysObj.setProperty(R50Frame.Index_UserDefinedName, (Object)fspQueryData.getIpAddress());
        this.mSysObj.setProperty(R50Frame.Index_State, (Object)new UnsignedInt8(254));
    }

    protected boolean repUpdateStateData(int n) throws RException {
        boolean bl = false;
        if (n != 254 && n != 250) {
            FspQueryData fspQueryData = this.mCmdMgr.getQueryData();
            int n2 = fspQueryData.getPendingPasswordChangeBitfield().intValue();
            if (this.setProperty("PasswordStatus", (Object)new UnsignedInt16(n2))) {
                bl = true;
            }
            int n3 = MsVersionInfo.isCompatible("V4R3.2", fspQueryData.getInterfaceVersionFamily().intValue(), fspQueryData.getFspType().intValue(), fspQueryData.getMajorVersion().intValue(), fspQueryData.getMinorVersion().intValue(), fspQueryData.getBrand().intValue());
            System.out.println("MsVersionInfo.isCompatible " + n3);
            if (n3 != 0) {
                n = 250;
            }
        }
        if (n == 14 || n == 4) {
            return false;
        }
        return this.mSysObj.setProperty(R50Frame.Index_State, (Object)new UnsignedInt8((short)n));
    }

    protected boolean reinitialize() {
        return false;
    }

    public void updateSysAll() throws PIHscServerException {
        this.mAsyncHandler.reinitialize();
        this.mFrameUpdater.update();
    }

    public void sysDisconnected(long l) {
        try {
            RObject rObject = (RObject)this.mSysObj.clone();
            if (this.mSysObj.setProperty(R50Frame.Index_State, (Object)new UnsignedInt8(254))) {
                this.sendModifiedIndication(rObject);
            }
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    public void deleteSysAll() throws PIHscServerException, RException {
        this.mCmdMgr.close(true);
        this.mSysObj.deleteAssociated(R50Define.AID_IBMHSC_FrameCage);
        super.deleteSysAll();
    }

    protected void deleteConn(FspQueryData fspQueryData) {
        try {
            OmHostsInfo.deleteBpcIpInfo((byte)fspQueryData.getFspRole().intValue(), this.mSysName);
            super.deleteConn(fspQueryData);
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    public void lockFrame() throws PIHscServerException {
        this.mCmdHelper.bpaSetLock(OmConsoleMgr.getConsoleMgr().getHmcId());
    }

    public void unlockFrame() throws PIHscServerException {
        this.mCmdHelper.bpaClearLock(OmConsoleMgr.getConsoleMgr().getHmcId());
    }

    protected void unlockSysAll() throws PIHscServerException {
        try {
            this.unlockFrame();
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            System.out.println("unlock frame failed");
        }
    }

    protected void sentCreationEvent() {
    }

    void userDefNameChanged() {
        this.mFrameUpdater.updateUserDefName();
    }

    void frameNumChanged() {
        this.mFrameUpdater.updateFrameNum();
    }

    void frameInfoChanged() {
        this.mFrameUpdater.updateFrameInfo();
    }

    void bpcStateChanged() {
        this.mFrameUpdater.updateFrameState();
    }

    public int getSysType() {
        return 1;
    }

    public int platformPassword(String string) throws PIHscServerException {
        int n = super.platformPassword(string);
        return n;
    }

    public int setPassword(UnsignedInt8 unsignedInt8, String string, String string2) throws PIHscServerException {
        int n = super.setPassword(unsignedInt8, string, string2);
        return n;
    }

    private void setBpcPassword(String string) throws PIHscServerException {
        Hashtable hashtable = this.mCmdMgr.getAllConnInfo();
        Enumeration enumeration = hashtable.elements();
        while (enumeration.hasMoreElements()) {
            FspQueryData fspQueryData = (FspQueryData)enumeration.nextElement();
            try {
                String string2 = fspQueryData.getIpAddress();
                System.out.println("host " + string2);
                InetAddress inetAddress = InetAddress.getByName(string2);
                String string3 = inetAddress.getHostAddress();
                System.out.println("ip " + string3);
                OmHostsInfo.setPassword((byte)fspQueryData.getFspRole().intValue(), this.mSysName, string2, string, string3);
                this.bpcIsReady(fspQueryData, true);
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
                if (throwable instanceof PIHscServerException) {
                    throw (PIHscServerException)throwable;
                }
                System.out.println("cannot get ip");
                OmHostsInfo.setPassword((byte)fspQueryData.getFspRole().intValue(), this.mSysName, fspQueryData.getIpAddress(), string);
            }
        }
    }

    void bpcIsReady() {
        Hashtable hashtable = this.mCmdMgr.getAllConnInfo();
        Enumeration enumeration = hashtable.elements();
        while (enumeration.hasMoreElements()) {
            FspQueryData fspQueryData = (FspQueryData)enumeration.nextElement();
            this.bpcIsReady(fspQueryData, false);
        }
    }

    private void bpcIsReady(FspQueryData fspQueryData, boolean bl) {
        if (fspQueryData.getCmdServerConnState().intValue() != 0) {
            System.out.println("conn state is " + fspQueryData.getCmdServerConnState().intValue() + " cannot push down bpc ip info.");
            return;
        }
        try {
            int n;
            UnsignedInt8[] unsignedInt8Array;
            if (bl) {
                unsignedInt8Array = (UnsignedInt8[])this.getObject().clone();
                n = this.updIntfCapNoException();
                if (n != 3 && n != 4) {
                    if (n == 1 || n == 5) {
                        this.sendModifiedIndication((RObject)unsignedInt8Array);
                    }
                    return;
                }
            }
            unsignedInt8Array = (UnsignedInt8[])this.mSysObj.getProperty(R50Frame.Index_Capability);
            n = 0;
            if (unsignedInt8Array != null && unsignedInt8Array.length > 5 && (unsignedInt8Array[5].intValue() & 0x10) != 0) {
                n = 1;
            }
            String string = fspQueryData.getIpAddress();
            InetAddress inetAddress = InetAddress.getByName(string);
            String string2 = inetAddress.getHostAddress();
            int n2 = fspQueryData.getFspRole().intValue();
            System.out.println("calling OmHostsInfo.setReady sysName: " + this.mSysName + " side: " + n2 + " host: " + string + " ip: " + string2 + " pwStatus: " + n);
            if (OmHostsInfo.setReady((byte)n2, this.mSysName, string, string2, n)) {
                System.out.println("setReady return true");
                OmCecMgr.pushDownBpcIpInfo2AllCecs();
                System.out.println("after push all fsps");
            }
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    public RObject getCageObject(String string) throws RException {
        Vector vector = this.mSysObj.associators(R50Define.AID_IBMHSC_FrameCage);
        if (vector != null) {
            Iterator iterator = vector.iterator();
            while (iterator.hasNext()) {
                RObject rObject = (RObject)iterator.next();
                String string2 = (String)rObject.getProperty(R50Cage.Index_Name);
                if (!string2.equals(string)) continue;
                return rObject;
            }
        }
        return null;
    }

    public RObjectId getCageObjectId(String string) throws RException {
        RObject rObject = this.getCageObject(string);
        if (rObject != null) {
            return rObject.getObjectId();
        }
        return null;
    }

    public void powerOffUnownedCages() throws RException, PIHscServerException {
        Vector vector = this.mSysObj.associators(R50Define.AID_IBMHSC_FrameCage);
        String string = "Power off following unowned cage failed: \n";
        boolean bl = false;
        if (vector != null) {
            Iterator iterator = vector.iterator();
            while (iterator.hasNext()) {
                int n;
                RObject rObject = (RObject)iterator.next();
                UnsignedInt8 unsignedInt8 = (UnsignedInt8)rObject.getProperty(R50Cage.Index_CageType);
                if (unsignedInt8 == null || (n = unsignedInt8.intValue()) != 32 && n != 33 && n != 34 && n != 47) continue;
                UnsignedInt16 unsignedInt16 = (UnsignedInt16)rObject.getProperty(R50Cage.Index_CageStatus);
                String string2 = (String)rObject.getProperty(R50Cage.Index_OwnerMtms);
                if ((unsignedInt8 == null || unsignedInt16.intValue() != 32768) && (string2 == null || string2.length() >= 1)) continue;
                String string3 = (String)rObject.getProperty(R50Cage.Index_Name);
                UnsignedInt8 unsignedInt82 = new UnsignedInt8(string3.substring(0, string3.indexOf("*")));
                try {
                    this.mCmdHelper.powerOffCage(unsignedInt82);
                }
                catch (Throwable throwable) {
                    throwable.printStackTrace();
                    String string4 = " with unknown reason.";
                    if (throwable instanceof PIHscCmdMgrException) {
                        PIHscCmdMgrException pIHscCmdMgrException = (PIHscCmdMgrException)throwable;
                        byte[] byArray = pIHscCmdMgrException.getMessagePayload();
                        if (pIHscCmdMgrException.getStatus() != 0 && byArray != null && byArray.length > 0) {
                            byte by = byArray[0];
                            if (by == 33) {
                                string4 = " cage is not present or not configured.";
                            }
                            if (by == 37) {
                                string4 = " invalid destination.";
                            }
                        }
                    }
                    string = string + string3 + ": " + string4 + "\n";
                    bl = true;
                }
            }
            if (bl) {
                System.out.println("Power off unowned cages failed: " + string);
                throw new PIHscServerException(string);
            }
        }
    }
}

